<?php

class SimpleDatabase {
    private $host = 'localhost';
    private $dbname = 'pb';
    private $username = 'pb';
    private $password = 'lE0lX0oR0b';
    private $charset = 'utf8mb4';

    private $pdo;
    private $error;

    public function __construct() {
        // DSN (Data Source Name)
        $dsn = "mysql:host=" . $this->host . ";dbname=" . $this->dbname . ";charset=" . $this->charset;
        
        $options = [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES   => false,
        ];
        
        try {
            $this->pdo = new PDO($dsn, $this->username, $this->password, $options);
        } catch (PDOException $e) {
            $this->error = $e->getMessage();
            echo "Connection error: " . $this->error;
        }
    }
    
    public function prepare($sql) {
        try {
            return $this->pdo->prepare($sql);
        } catch (PDOException $e) {
            $this->error = $e->getMessage();
            echo "Prepare error: " . $this->error;
            return false;
        }
    }

    public function execute($sql, $params = []) {
        try {
            $stmt = $this->pdo->prepare($sql);
            if ($stmt) {
                $stmt->execute($params);
                return $stmt;
            } else {
                return null; // Возвращаем null, если подготовка запроса не удалась
            }
        } catch (PDOException $e) {
            $this->error = $e->getMessage();
            echo "Execution error: " . $this->error;
            return null; // Возвращаем null при возникновении ошибки
        }
    }

    public function select($sql, $params = []) {
        $stmt = $this->execute($sql, $params);
        if ($stmt !== null) {
            return $stmt->fetchAll();
        } else {
            return false; // Возвращаем false, если запрос не удался
        }
    }
    
    public function fetchAll($stmt) {
        return $stmt->fetchAll();
    }
}


?>