<?php
// IP-адрес для проверки
$testIp = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0'; // Для тестов заменить на реальный IP
//$testIp='66.249.79.102';
$hardcodedIp = '3.122.75.50'; // Хардкод IP-адреса для проверки

// Файлы JSON с диапазонами
$files = ['ip1.json', 'ip2.json', 'ip3.json'];

// Функция для проверки принадлежности IP к диапазону
function ipInRange($ip, $range) {
    if (strpos($range, '/') !== false) {
        list($rangeBase, $prefix) = explode('/', $range);
        $prefix = (int)$prefix;
        $rangeDecimal = ip2long($rangeBase);
        $ipDecimal = ip2long($ip);
        $mask = ~((1 << (32 - $prefix)) - 1);
        return ($ipDecimal & $mask) === ($rangeDecimal & $mask);
    }
    return false;
}

// Считывание данных из файлов
$allRanges = [];
foreach ($files as $file) {
    if (file_exists($file)) {
        $content = file_get_contents($file);
        $json = json_decode($content, true);
        if (isset($json['prefixes'])) {
            foreach ($json['prefixes'] as $prefixData) {
                if (isset($prefixData['ipv4Prefix'])) {
                    $allRanges[] = $prefixData['ipv4Prefix'];
                }
            }
        }
    } else {
        echo "Файл $file не найден.\n";
    }
}

// Проверка IP-адреса
function checkIpAgainstRanges($ip, $ranges) {
    foreach ($ranges as $range) {
        if (ipInRange($ip, $range)) {
            return true;
        }
    }
    return false;
}

$ok1=0;
$ok2=0;
//echo "Проверяем IP-адрес клиента ({$testIp})...\n";
if (checkIpAgainstRanges($testIp, $allRanges)) {
    $ok1=1;
    //echo "IP-адрес клиента входит в диапазоны.\n";
}

//echo "Проверяем хардкод IP ({$hardcodedIp})...\n";
if (checkIpAgainstRanges($hardcodedIp, $allRanges)) {
    $ok2=1;
}

if($ok1 != 1 && $ok2 != 1) {
    header('HTTP/1.1 403 Forbidden');
    header('Content-Type: text/plain; charset=utf-8');

    // Вывод сообщения для клиента
    //echo "Access denied. You do not have permission to access this resource.";
    exit;
}